#code to evaluate how many dens cumulatively affected by total SBS development
setwd("...XXXX/BLM EA")#need to set to wherever you put unzipped folder 

require(sf)
require(spatstat)
require(raster)

#load impact area
impact = st_read("ITA_impact_area_20240821_AKAlbers.shp")
plot(impact[,1])

#load den sims
sim.dens = readRDS("../BLMoutput/sim.dens2024-2025_20240807_112853.783789.rds")

#set projection
proj="+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs"
study.proj=crs(proj)
impact.proj = st_transform(impact,study.proj)


dens.ppp = lapply(sim.dens,FUN=function(dens) ppp(dens$x,dens$y,window=owin(xrange=range(dens$x),yrange=range(dens$y))) )
 
dev.obj = as.owin(impact.proj)
dev.dist.fun = distfun.owin(dev.obj)

dens.d2dev = lapply(dens.ppp,FUN=function(xx) dev.dist.fun(xx) )

dens.inbuff = unlist(lapply(dens.d2dev, FUN = function(xx) sum(xx==0)))
dens.count = unlist(lapply(dens.d2dev, length))
dens = data.frame(exposed=dens.inbuff,total.dens=dens.count,pct.impact=dens.inbuff/dens.count)

#impacted dens
mean(dens.inbuff)
quantile(dens.inbuff,c(.025,.5,.975))

#total dens simulated
mean(dens.count)
quantile(dens.count,c(.025,.5,.975))

#percent of total simulated dens that are impacted
mean(dens$pct.impact)
quantile(dens$pct.impact,c(.025,.5,.975))


